/*
  Demo Programm zur Visualisierung von Morsezeichen
  by DL5PD, Rainer Dohmen für Fieldday 2016 von K30
  2016-07-17 initial program
  2016-08-01 Piezo Summer hinzugefuegt
  2016-08-03 variablen Speed eingefuegt, Ton wahlweise ein- und ausschaltbar
  TODO: - variablen Speed via Poti realisieren, Ton via Hardware ein u. ausschalten
  Lizenz: Attribution-ShareAlike 4.0 International (CC BY-SA 4.0)
 */

// 2 Arrays für Buchstaben und Ziffern
const char* alphabet[] = {"01", "1000", "1010", "100","0", "0010", "110", "0000", "00", "0111", "101", "0100", "11", "10", "111", "0110", "1101", "010", "000", 
                          "1", "001", "0001", "011", "1001", "1011", "1100"};
const char* ziffern[] = {"11111", "01111", "00111", "00011", "00001", "00000", "10000", "11000", "11100", "11110"};

String text = "sos sos sos willkommen bei k30"; //pre-defined text, falls nichts über die serielle Schnittstelle kommt.

int bufferCount;    // Anzahl der eingelesenen Zeichen
char puffer[80];    // Serial Input-Buffer
boolean avail;      // Textende-Erkunnung, um aus der WHILE-Schleife "auszubrechen"
int speed = 60;     // Geschwindigkeit der Ausgabe in BPM
boolean audio = 1;  // Piezo-Summer ein (1) oder aus (0)

void setup() {
  pinMode(13, OUTPUT); // interne Kontroll-LED zur Ausgabe
  pinMode(8, OUTPUT);  // externe LED-Ausgabe via Treiberstufe auf LED-Lichtleiste
  pinMode(9, OUTPUT);  // Ausgang zur Audio-Ausgabe
  Serial.begin(9600);  // serielle Schnittstelle initialisieren mit 9k6 Geschwindigkeit

}

void loop() {
  // falls Text über die serielle Schnittstelle kommt, diesen bis "ENTER"
  // einlesen, in Kleinbuchstaben umwandeln und den vordefinierten Text überschreiben
  if (Serial.available() > 0) {
    avail = 1;
    while (avail) {
      char ch = Serial.read();
      puffer[bufferCount] = ch;
      bufferCount++;
      // Hier löschen wir den Puffer, damit alles wieder von vorne anfangen kann
      // und der Text eine beliebige Länge haben dar (<= 80 Zeichen)
      if (ch == 13) {
        text = puffer;
        text.toLowerCase();
        memset(&puffer[0], 0, sizeof(puffer));
        bufferCount=0;
        avail = 0;
      }
    }
  }
  // vordefinierten bzw. neuen Text auf die serielle Schnittstelle ausgeben
  Serial.println(text);
  // Prüfung, ob Buchstabe oder Ziffer vorliegt, Zuweisung zu "Morse-Array"
  for (int z=0; z < text.length(); z++)
  {
    if (isDigit(text[z])) ausgabe(ziffern[chartoarray(text[z])]);
    if (isAlpha(text[z])) ausgabe(alphabet[chartoarray(text[z])]);
    Serial.println();
    // bei Leerzeichen eine kurze Pause einfügen
    if (int(text[z]) == 32) delay(6000/speed*7);
    // Pause zwischen Zeichen einfügen
    delay(6000/speed*3);
  }
  // Zeilenumbruch einfügen
  Serial.println();
  // Pause vor nächstem Durchgang einlegen
  delay(6000/speed*15);
}

int chartoarray(char zeichen) {
  /* Funktion, um Zeichen in gültigen Array-Wert umzuwandeln
   * mit Hilfe des ASCII-Wertes
   * vorher Ausgabe des Zeichens über die serielle Schnittstelle
   * zur Kontrolle 
   */
  Serial.print(zeichen); Serial.print("  ");
  if (isDigit(zeichen)) {
    return int(zeichen) - 48;
  }
  if (isAlpha(zeichen)) {
    return int(zeichen) - 97;
  }
  
}

void ausgabe(String buchstabe) {
  /* Funktion, um den Morse-Code
   *  1. auf die serielle Schnittstelle (. ist kurz, - ist lang),
   *  2. optisch auf die interne und die externen LED(s) und
   *  3. akustisch auszugeben
   */
  for (int z=0; z < buchstabe.length(); z ++) {
    if (buchstabe[z] == '1') {
      Serial.print("-");
      digitalWrite(13, HIGH);
      digitalWrite(8, HIGH);
      if (audio) tone(9,440);
      delay(6000/speed*3);
      digitalWrite(13, LOW);
      digitalWrite(8, LOW);
      if (audio) noTone(9);
      delay(6000/speed);
    }
    else {
      Serial.print(".");
      digitalWrite(13, HIGH);
      digitalWrite(8, HIGH);
      if (audio) tone(9,440);
      delay(6000/speed);
      digitalWrite(13, LOW);
      digitalWrite(8, LOW);
      if (audio) noTone(9);
      delay(6000/speed); 
    }
  }
}

